subroutine epSmpTargertBrems(tmin, tmax, gf, t, icon)
  implicit none
  ! sample photon energy (in unit of Me) for the
  ! target brems at high energy
  real(8),intent(in):: tmin  ! min photon energy /Me
  real(8),intent(in):: tmax  ! max //
  real(8),intent(in):: gf  ! let the gamma factor of the
  ! an incident charged particl(e ( heavier than muon)
  ! gf = 2 ln(2g).   g  must be large so that energy is > 100GeV.
  real(8),intent(out):: t ! smapled energy /Me.
  integer,intent(out):: icon ! 0 OK, 1 somthing wronng  (say,
  ! tmin >= tmax,

  !  emitted photon energy distribution  can be expessed
  !        log(2t) (gf - log(2t) )/t^2 dt
  !             using y = log(2t) 
  !       ==>2y(gf-y) exp(-y) dy
  !       = 2[ gf * y* exp(-y) - y^2 exp(-y) ] dy
  !  sample y first and get t= log(y)/2.
  ! for large gf, main term is the first one.

  real(8):: y,  f1, f2, f, u, expy

!!!!!!!!!
  integer:: ret1, ret2
!!!!!!!  
  if( tmin >= tmax ) then
     icon = 1
     write(0,*) tmin, tmax, ' invalid for  epSmpTargertBrems'
     stop
  endif
  ! same from y exp(-y)
  ret2  = 0

  do
     !!!!!!!
     ret1 = 0
     !!!!!!!!!!
     do
        !   y exp(-y) dy
        call ksgmis(1, 1.0d0, y)
        if(y >= tmin .and. y <= tmax) exit
        ret1 = ret1 + 1
     enddo

     write(0,*)  y
     
  ! rejection

     expy =  exp(-y)
     f2 =  y*y*expy
     f1 =  gf*y*  expy
     f  = f1 - f2
  !       = 2[ gf * y* exp(-y) - y^2 exp(-y) ] dy

     write(0,*)  'f1, f2', f1, f2, f
     
     call rndc(u)
     if( u < f1/f ) exit
     ret2 = ret2 + 1
  enddo
  t = 1./expy/2
  icon = 0
  
  write(*,*) "# ret", ret1, ret2
  
end subroutine epSmpTargertBrems

subroutine epTargetBremsFunc(tmin, tmax, gf)
  implicit none
  ! sample photon energy (in unit of Me) for the
  ! target brems at high energy
  real(8),intent(in):: tmin  ! min photon energy /Me
  real(8),intent(in):: tmax  ! max //
  real(8),intent(in):: gf  ! let the gamma factor of the

  real(8):: t ! smapled energy /Me.

  real(8):: f1, f2, f, y, expy, dt
  ! 2[ gf * y* exp(-y) - y^2 exp(-y) ]

  t = tmin
  dt = 10**0.025
  write(*,'("#  t(Me unit)   y=log(2t)  f1=gf*y*exp(-y)  f2=y^2exp(-y)  f=f1-f2   y(gf-y)/t/t")')
  do while ( t< tmax)
     y= log(2*t)
     expy = exp(-y)
     f1= gf * y * expy
     f2 = y**2 * expy
     f = f1 - f2
     write(*,'("#tyf ",1p, 7g12.4)') t, y, f1, f2, f1-f2, y*(gf-y)/t/t
     t = t*dt
  enddo

end subroutine epTargetBremsFunc
     

program  main
  implicit none
  real(8):: tmin, tmax, me, g, M, E, beta, gb2, gf, t
  integer:: icon, i
  
  me = 0.511d-3  
  M = 16
  E = 1000000.
  g = E/M
  beta = sqrt(1.0d0 - 1.0d0/g/g)

  gb2 = (g *beta)**2

  tmax = 2*gb2/ ( 1 + 2*g*(me/M) + (me/M)**2 )

  tmin = 10e-6/me 

  write(0,*) ' tmin tmax =', tmin, tmax
  
  gf = 2* log(2*g)


  call  epTargetBremsFunc(tmin, tmax, gf)
  
  do i = 1, 100000
     call  epSmpTargertBrems(tmin, tmax, gf, t, icon)
     if(icon == 0) then
        write(*, *) t*me
     endif
  enddo
end program main
