!   ifort   -L$EPICSTOP/lib/PCLinuxIFC64 -lepics
!   -L$COSMOSTOP/lib/PCLinuxIFC64 -lcosmos

!    compute Moliere's F0, F1, F2 
!  which is
! 2pi  f(theta) theta dtheta = ( F0(x)  + F1(x)/B   F2(x)/B^2) dx
!                 F0= 2exp(-x)
!                 F1 = epMoliere1(x)
!                 F2 = epScotD2(x) (don't use epMoliere2)
!   x = teta^2 (teta reduced angle; rad^2)
!  
!
program main
implicit none
real(8):: teta, x
real(8),external:: epMolfunc1, epScotD2
real(8):: f0, f1, f2, B
!!
!!/////////////
   B=1.
   write(0,*) 'Enter B'
   read(*,*) B
   teta = 0.
   write(*,'(a)') &
     "# B, teta, x, f0, f1/B, f2/B**2, f0+f1/B+f2/B/B"
   do while( teta<14.)
      x = teta**2
      f0 = 2*exp(-x)
      f1 = epMolfunc1(x)
      f2 = epScotD2(x)
      write(*,'(1p,7g13.4)') B, teta, x, f0, f1/B, f2/B**2, f0+f1/B+f2/B/B
      teta = teta + 0.001d0
   enddo
   write(*,*) " "
end program main
