! ifort epScotD2.f90 epMolfunc.f90  -L$EPICSTOP/lib/PCLinuxIFC64 -lepics -L$COSMOSTOP/lib/PCLinuxIFC64 -lcosmos
!program main
!implicit none
!real(8)::x, teta, f2 
!real(8)::epScotD2
!teta = 0.0d0
!do while (teta< 13.d0)
!   x = teta ** 2
!   f2 = epScotD2(x)
!   write(*,*) teta, f2, x
!   teta = teta + 0.1d0
!enddo
!end program main
!
!
function epScotD2(x)
  implicit none
! Moliere's F2(x) :SCOT Rev.Mod.Phys. (A24)
!  (p.311). with alpha=3, beta=1
! 
!       at around x=teta^2 =4.2^2, the accuracy
!   is  worst ( 3 digit accuracy).
!   at others, much more accurate.
! With Bethes forumulat in Phys. Rev. I couldn't
! get correct result although numerical table
! by Bethe and Scot coinside.
!
!  G(1) SUM  G(3+k)(-x)^k/(k!G(1+k))
!      x   (  Psi^2(0,2+k) + Psi(1,2+k)  )
!  SUM is over k=0 to inf.
!  G(x) = gamma(x)
!  Psi(n,x)  = kpolyg(n,x+1)    
  real(8)::epScotD2
  real(8):: x  ! reduced theta^2
  
  real(8)::kpolyg, kgamma
  real(8),parameter:: bigx=4.21*4.21
  integer k

  logical,save:: first= .true.
  real(8):: fac, psi1, psi2, xk, sum, term, termold
  real(8):: temp, temp2, temp3, xbyfac, facbyx, temp1

  real(8):: epPsi
  real(8),parameter:: eps= 1.d-5
  
  
  if( x < bigx ) then
     
!  G(1) SUM  G(3+k)(-x)^k/(k!G(1+k))
!      x   (  Psi^2(0,2+k) + Psi(1,2+k)  )

!  SUM k=0, 1, ..
!    (k+2)! /k!/k! = (k+2)(k+1)/k! 
     psi1 = epPsi(0, 2.d0)
     psi2 = epPsi(1, 2.d0)
     sum = 2.* (psi1**2 + psi2)
     xbyfac = 1.
     if(x /= 0. ) then
        do k = 1, 200
!           k+2 :  k+1
!           psi2 = psi2 - 1.d0/(k+1)**2
           temp = k + 3
           temp2 = k + 1
           temp3 = k+2
           psi1 = psi1 + 1.d0/temp3
              !           psi1 = epPsi(0, temp3)
              !           psi2 = epPsi(1,temp3)
           psi2 = psi2 - 1.d0/temp3**2
              !           term = kgamma(temp)* (-x)**k/ kgamma(temp2)**2  * &
           xbyfac = xbyfac*(-x)/k
           !           term =temp3*temp2 * (-x)**k/ kgamma(temp2)  * &
           term =temp3*temp2 * xbyfac  *   (psi1**2 + psi2)
           sum = sum + term
           if( abs(term /sum) < eps) exit
        enddo
     endif
  else
! For large x; m=2, beta=1; use asymptotic expansion
!   D2(b+m, b, -x) = 2(-1)G(1)/x^3 SUM
!           x [ G(3+k)(2+k)!/(k! x^k  )]
!           x [ psi(0, 2+k) + psi(0,2+k)-log(x) ]
!   psi(k+2) = psi(k+1)+1/(k+1)
!  SUM from k=0 to n; n some artibtray number.
!   k =0;
     psi1 = epPsi(0, 2.d0)  ! k+2

     sum = 4.0 * (2* psi1  - log(x))
     facbyx = 2.
     do k = 1, 50
!        facbyx = (k+1)*facbyx/x
        temp1 = k + 1
        temp2 = k + 2
        temp3 = k + 3
!        facbyx = kgamma(temp3)/x**k
        facbyx = facbyx*temp2/x
        psi1 = epPsi(0, temp2)
        term = facbyx * (k+2)*(k+1)*(2*psi1  - log(x))
        if(k>8) then
           if(abs(term) > abs(termold)) exit
        endif
        termold = term
        sum = sum + term
        if( abs( term/ sum) < eps )  exit
     enddo
     sum = -2* sum /x**3
  end if
  epScotD2 = sum
end function epScotD2
