      PROGRAM XBIN5
C     DATAPAC BINARY FILE PREP, 26 FEB 91.
C        INCLUDES PHOTON CROSS SECTIONS AND FORM FACTORS
C        VERSION B, FOR NIM & ATDATA PHIRAD.
C
C           STEPHEN M. SELTZER
C           NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C           GAITHERSBURG, MD 20899
C           (301) 975-5552
C
      CHARACTER  COMNT*66,TAG*72,FILENM*7,SUF(10)*21,ADG(14)*2,
     1   HEAD*76,ID*6,CARD*14
      DIMENSION  T(5001),S(1001),R(31,5),XSEC(57,30),TS(25,25)
      DIMENSION  IDG(14),EDGEN(14),E(108),SCATCO(108),SCATIN(108),
     1   PHOT(108),PAIRAT(108),PAIREL(108),PHC(35,14) 
      DIMENSION  TR(57),PHIRAD(57),ETA(57),TRL(57),TZSQ(28),
     1   TZSQL(28),POSRAT(28),TETA(28),TETAL(83),POSETA(28),
     2   NSHELL(100),IZS(100,27),BS(100,27)
      DIMENSION  XX(45),IXX(45),X(45),FF(45),IFF(45),F(45),
     1   SS(45),ISS(45),SF(45)
      DATA  SUF/'01','02','03','04','05','06','07','08','09','10'/
   20 FORMAT (A)
      PRINT 285
  285 FORMAT (' Filing atomic binding energies')
C        * ATOMIC SUB-SHELL BINDING ENERGIES
      OPEN (UNIT=9,FILE='BINDENGY.DAT')
      OPEN (UNIT=10,FORM='UNFORMATTED',FILE='BINDENGY.BIN')
      READ  (9,20) DEFY
      DO 300 J=1,100
      READ  (9,60) IZZ,NSHELL(J)
      WRITE (10) IZZ,NSHELL(J)
      NSHL=NSHELL(J)
      READ  (9,290) (IZS(J,N),BS(J,N),N=1,NSHL)
      WRITE (10) (IZS(J,N),BS(J,N),N=1,NSHL)
  290 FORMAT (5(I3,F11.3))
  300 CONTINUE
      CLOSE (9)
      CLOSE (10)
      PRINT 10
   10 FORMAT (' Filing photon cross-section database')
C        * PHOTON CROSS SECTIONS
      OPEN (UNIT=10,ACCESS='DIRECT',RECL=4740,FORM='UNFORMATTED',
     1   FILE='PHOTX.BIN')
      MAXEP=0
      DO 40 I=1,14
      IDG(I)=0
      ADG(I)='AA'
      EDGEN(I)=0.0
      DO 40 M=1,35
   40 PHC(M,I)=0.0 
      DO 175 KS=1,10
      FILENM='PHOTX'//SUF(KS)
      OPEN (UNIT=9,FILE=FILENM)
      KFST=(KS-1)*10+1
      KLST=KFST+9
      DO 170 K=KFST,KLST
      READ (9,50) IZ,ATWT
   50 FORMAT (I6,F12.6)
      READ (9,60) MAXEDG,MAXE
   60 FORMAT (12I6)
      IF(MAXEDG)110,110,70
   70 READ (9,60) (IDG(I),I=1,MAXEDG)
      READ (9,90) (ADG(I),I=1,MAXEDG)
   90 FORMAT (14(1X,A2))
      READ (9,100) (EDGEN(I),I=1,MAXEDG)
  100 FORMAT (8F9.1)
  110 READ (9,120) (E(M),M=1,MAXE)
  120 FORMAT (1P6E13.6)
      READ (9,130) (SCATCO(M),M=1,MAXE)
  130 FORMAT (1P8E10.3)
      READ (9,130) (SCATIN(M),M=1,MAXE)
      READ (9,130) (PHOT(M),M=1,MAXE)
      READ (9,130) (PAIRAT(M),M=1,MAXE)
      READ (9,130) (PAIREL(M),M=1,MAXE)
      IF(MAXEDG)160,160,140
  140 READ (9,60) MAXEP
      DO 150 M=1,MAXEP
      READ (9,130) (PHC(M,I),I=1,MAXEDG)
  150 CONTINUE
  160 KR=K
      WRITE (10,REC=KR) IZ,ATWT,MAXEDG,MAXE,IDG,ADG,EDGEN,E,
     1 SCATCO,SCATIN,PHOT,PAIRAT,PAIREL,MAXEP,PHC
  170 CONTINUE
      CLOSE (9)
  175 CONTINUE
      CLOSE (10)
C        * ATOMIC FORM AND INCOHERENT SCATTERING FACTORS
      OPEN (UNIT=9,FILE='FANDS.DAT')
      OPEN (UNIT=10,FORM='UNFORMATTED',FILE='FSX.BIN')
      OPEN (UNIT=11,ACCESS='DIRECT',RECL=360,FORM='UNFORMATTED',
     1   FILE='FSFAC.BIN')
      READ (9,400) NMAX,HEAD
  400 FORMAT (I4,A)
      READ (9,410) (XX(N),IXX(N),N=1,NMAX)
  410 FORMAT (10(F5.2,I3))
      DO 420 N=1,NMAX
  420 X(N)=XX(N)*(10.0**IXX(N))
      WRITE (10) NMAX
      WRITE (10) X
      READ (9,400) LMAX,HEAD
      DO 460 L=1,100
      READ (9,430) ID,CARD
  430 FORMAT (A,60X,A)
      READ (9,440) (FF(N),IFF(N),N=1,NMAX)
      READ (9,440) (SS(N),ISS(N),N=1,NMAX)
  440 FORMAT (6(F8.5,I3))
      DO 450 N=1,NMAX
      F(N)=FF(N)*(10.0**IFF(N))/REAL(L)
      SF(N)=(SS(N)*(10.0**ISS(N)))/REAL(L)
  450 CONTINUE
      WRITE (11,REC=L) F,SF
  460 CONTINUE
      PRINT 177
  177 FORMAT (' Filing elastic-scattering data')
C        * FANO INELASTIC SCATTERING CORRECTION
      OPEN (UNIT=9,FILE='FANO.COR')
      OPEN (UNIT=10,ACCESS='DIRECT',RECL=4,FORM='UNFORMATTED',
     1   FILE='FANO.BIN')
      READ (9,20) TAG
      READ (9,60) MAXZ
      READ (9,180) (T(M),M=1,MAXZ)
  180 FORMAT (6F12.5)
      DO 190 M=1,100
      WRITE (10,REC=M) T(M)
  190 CONTINUE
      CLOSE (9)
      CLOSE (10)
C        * MOTT/RUTH RATIOS
      OPEN (UNIT=9,FILE='MOTTX2.DAT')
      OPEN (UNIT=10,FORM='UNFORMATTED',FILE='MOTTE2.BIN')
      READ  (9,20) TAG
      READ (9,60) NMOT,NANG
      WRITE (10) NMOT,NANG
      READ (9,195) (T(N),N=1,NMOT)
  195 FORMAT (1P6E12.5)
      WRITE (10) (T(N),N=1,NMOT)
      CLOSE (10)
      OPEN (UNIT=10,ACCESS='DIRECT',RECL=620,FORM='UNFORMATTED',
     1   FILE='MOTTX2.BIN')
      DO 220 M=1,100
      DO 210 I=1,2
      READ (9,200) IZ
  200 FORMAT (4X,I4)
      NREC=2*M-2+I
      READ (9,195) ((R(N,J),N=1,NMOT),J=1,NANG)
      WRITE (10,REC=NREC) ((R(N,J),N=1,NMOT),J=1,NANG)
  210 CONTINUE
  220 CONTINUE
      CLOSE (9)
      CLOSE (10)
C        * COSINE FACTOR IN MOTT/RUTH RATIO
      OPEN (UNIT=9,FILE='CHB.TAB')
      OPEN (UNIT=10,FORM='UNFORMATTED',FILE='CHB.BIN')
      READ (9,20) TAG
      READ (9,230) (T(N),N=1,280)
  230 FORMAT (1P5E14.7)
      WRITE (10) (T(N),N=1,280)
      CLOSE (9)
      CLOSE (10)
C        * LOW-ENERGY SCREENING ETA'S
      OPEN (UNIT=9,FILE='SCRETA.DAT')
      OPEN (UNIT=10,FORM='UNFORMATTED',FILE='SCRETAE.BIN')
      READ  (9,20) TAG
      NMAX=11
      WRITE (10) NMAX
      READ (9,*) (T(N),N=1,NMAX)
      WRITE (10) (T(N),N=1,NMAX)
      CLOSE (10)
      OPEN (UNIT=10,ACCESS='DIRECT',RECL=48,FORM='UNFORMATTED',
     1   FILE='SCRETA.BIN')
      DO 236 M=1,100
      READ (9,232) IZ,ADJM
  232 FORMAT (4X,I4,F10.5)
      DO 234 I=1,2
      NREC=2*M-2+I
      READ (9,*) (ETA(N),N=1,NMAX)
      WRITE (10,REC=NREC) (ETA(N),N=1,NMAX),ADJM
  234 CONTINUE
  236 CONTINUE
      CLOSE (9)
      CLOSE (10)
      PRINT 238
  238 FORMAT (' Filing bremsstrahlung database')
C        * BREMSSTRAHLUNG SPECTRAL DISTRIBUTIONS
      OPEN (UNIT=9,FILE='BREMS0')
      OPEN (UNIT=10,FORM='UNFORMATTED',FILE='BREME.BIN')
      DO 240 IC=1,4
      READ (9,20) TAG
  240 CONTINUE
      READ (9,60) NMAX,KMAX
      WRITE (10) NMAX,KMAX
      READ (9,180) (T(N),N=1,NMAX)
      WRITE (10) (T(N),N=1,NMAX)
      READ (9,180) (S(K),K=1,KMAX)
      WRITE (10) (S(K),K=1,KMAX)
      CLOSE (9)
      CLOSE (10)
      OPEN (UNIT=10,ACCESS='DIRECT',RECL=6840,FORM='UNFORMATTED',
     1   FILE='BREMX.BIN')
      DO 262 L=1,10
      FILENM='BREMS'//SUF(L)
      OPEN (UNIT=9,FILE=FILENM)
      MFST=(L-1)*10+1
      MLST=MFST+9
      DO 260 M=MFST,MLST
      DO 250 N=1,NMAX
      READ (9,180) (XSEC(N,K),K=1,KMAX)
  250 CONTINUE
      WRITE (10,REC=M) ((XSEC(N,K),N=1,NMAX),K=1,KMAX)
  260 CONTINUE
      CLOSE (9)
  262 CONTINUE
      CLOSE (10)
C        * POSITRON PHIRAD DATA
      OPEN (UNIT=9,FILE='POSRATB.DAT')
      READ  (9,20) DEFY
      READ  (9,60) MRAD,MRIX,LRIX
      MRIX1=MRIX+1
C        * T(MEV)/ZSQ
      READ  (9,310) (TZSQ(M),M=1,MRAD)
  310 FORMAT (1P6E12.1)
C        * P-N/E-N PHIRAD RATIO
      READ  (9,320) (POSRAT(M),M=1,MRAD)
  320 FORMAT (6F12.6)
      DO 330 M=1,MRAD
  330 TZSQL(M)=LOG(TZSQ(M))
C        * ENERGIES
      READ  (9,320) (TETA(M),M=1,MRIX)
C        * P-E/E-N PHIRAD RATIOS
      READ  (9,320) (POSETA(M),M=1,MRIX)
      DO 340 M=1,MRIX
  340 TETAL(M)=LOG(TETA(M))
      CLOSE (9)
      OPEN (UNIT=9,FILE='PHIRADB.DAT')
      OPEN (UNIT=10,FORM='UNFORMATTED',FILE='POSRATB.BIN')
      READ  (9,350) LMAX,COMNT
  350 FORMAT (I6,A)
C        * PHIRAD ENERGIES
      READ  (9,180) (TR(L),L=1,LMAX)
      DO 360 L=1,LMAX
  360 TRL(L)=LOG(TR(L))
      LRAX=LRIX-MRIX1
      MRAX=LMAX-LRAX
      DO 370 M=MRIX1,MRAX
  370 TETAL(M)=TRL(M+LRAX)
      WRITE (10) LMAX,MRAD,MRIX,MRIX1,LRIX,LRAX,MRAX
      WRITE (10) TZSQL,POSRAT
      WRITE (10) (TETAL(M),M=1,MRAX),(POSETA(M),M=1,MRIX)
      WRITE (10) TR,TRL
      CLOSE (10)
      OPEN (UNIT=10,ACCESS='DIRECT',RECL=456,FORM='UNFORMATTED',
     1   FILE='PHIRADB.BIN')
      DO 380 J=1,100
C        * E-N PHIRAD'S
      READ  (9,180) (PHIRAD(L),L=1,LMAX)
C        * E-E/E-N PHIRAD RATIOS
      READ  (9,180) (ETA(L),L=1,LMAX)
      WRITE (10,REC=J) PHIRAD,ETA
  380 CONTINUE
      CLOSE (9)
      CLOSE (10)
      PRINT 263
  263 FORMAT (' Filing straggling data')
C        * LANDAU AND GAUSSIAN DISTRIBUTIONS
      OPEN (UNIT=9,FILE='LANGUS88.DAT')
      OPEN (UNIT=10,FORM='UNFORMATTED',FILE='LANGUS88.BIN')
      READ (9,20) TAG
      READ (9,60)  NLAN,NGUS
      WRITE (10) NLAN,NGUS
      READ (9,265) (T(N),N=1,NLAN)
      READ (9,265) (S(N),N=1,NGUS)
  265 FORMAT (1P6E12.5)
      WRITE (10) (T(N),N=1,NLAN),(S(N),N=1,NGUS)
      CLOSE (9)
      CLOSE(10)
      PRINT 267
  267 FORMAT (' Filing photoelectron angle data')
C        * PHOTOELECTRON ANGULAR DISTRIBUTIONS
      OPEN (UNIT=9,FILE='PHOTEL.DAT')
      OPEN (UNIT=10,FORM='UNFORMATTED',FILE='PHOTEL.BIN')
      READ (9,20) TAG
      READ (9,60) NPEL,NEEL
      WRITE (10) NPEL,NEEL
      READ (9,230) (T(N),N=1,NPEL)
      READ (9,230) (S(N),N=1,NEEL)
      DO 270 M=1,NPEL
      READ (9,230) (TS(M,N),N=1,NEEL)
  270 CONTINUE
      WRITE (10) (T(N),N=1,NPEL),(S(N),N=1,NEEL),
     1   ((TS(M,N),M=1,NPEL),N=1,NEEL)
      CLOSE (9)
      CLOSE (10)
      PRINT 275
  275 FORMAT (' Filing pair-energy distributions')
C        * PAIR ENERGY DISTRIBUTIONS
      OPEN (UNIT=9,FILE='PAIRSHAR.DAT')
      OPEN (UNIT=10,FORM='UNFORMATTED',FILE='PAIRSHAR.BIN')
      READ (9,20) TAG
      READ (9,60) NPEL,NEEL
      WRITE (10) NPEL,NEEL
      READ (9,230) (T(N),N=1,NPEL)
      READ (9,230) (S(N),N=1,NEEL)
      DO 280 M=1,NPEL
      READ (9,230) (TS(M,N),N=1,NEEL)
  280 CONTINUE
      WRITE (10) (T(N),N=1,NPEL),(S(N),N=1,NEEL),
     1   ((TS(M,N),M=1,NPEL),N=1,NEEL)
      CLOSE (9)
      CLOSE (10)
      STOP
      END
